package com.bizvane.members.feign.model.bo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;

@Data
public class MbrGroupTypeDefMoveRequestParam {

    @ApiModelProperty("父分组目录code")
    @NotBlank(message = "父分组目录code不能为空")
    private String parentGroupTypeCode;

    @ApiModelProperty("分组目录code")
    @NotEmpty(message = "请选择二级分组目录")
    private List<String> mbrGroupTypeDefCodeList;

    @ApiModelProperty("操作人code")
    private String userCode;

    @ApiModelProperty("操作人")
    private String userName;
}
