package com.bizvane.members.feign.service;

import com.bizvane.members.feign.model.bo.MbrLicensePlateAddRequestParam;
import com.bizvane.members.feign.model.bo.MbrLicensePlateListRequestParam;
import com.bizvane.members.feign.model.bo.MbrStatusAddRequestParam;
import com.bizvane.members.feign.model.bo.MbrStatusListRequestParam;
import com.bizvane.members.feign.model.vo.MbrLicensePlateVO;
import com.bizvane.members.feign.model.vo.MbrStatusVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotBlank;

@FeignClient(value="${feign.client.members.name}",path="${feign.client.members.path}/mbrLicensePlate")
@Api("车牌管理")
public interface MbrLicensePlateFeign {

  @ApiOperation(value = "新增车牌")
  @RequestMapping(value="/add", method = RequestMethod.POST)
  ResponseData<String> add(@RequestBody MbrLicensePlateAddRequestParam param);

  @ApiOperation(value = "删除车牌")
  @RequestMapping(value="/delete", method = RequestMethod.POST)
  ResponseData<Boolean> delete(@RequestParam("mbrLicensePlateCode") @NotBlank String mbrLicensePlateCode);

  @ApiOperation(value = "查询车牌列表")
  @RequestMapping(value="/list", method = RequestMethod.POST)
  ResponseData<PageInfo<MbrLicensePlateVO>> list(@RequestBody MbrLicensePlateListRequestParam param);
}
