package com.bizvane.members.feign.model.bo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;

@Data
public class MbrLevelDefUpdateRequestParam {

    @NotNull
    @ApiModelProperty("等级code")
    private String mbrLevelDefCode;

    @NotNull
    @ApiModelProperty("等级编号")
    private String levelNo;

    @NotNull
    @ApiModelProperty("等级名称")
    private String levelName;

    @ApiModelProperty("等级排序值")
    private Integer levelValue;

    @ApiModelProperty("卡背景URL")
    private String cardBackUrl;

    @ApiModelProperty("文案颜色")
    private String wordColor;

    @ApiModelProperty("升降级规则开启状态：1-开启；0-关闭")
    private Boolean ruleStatus;

    @ApiModelProperty("升级累计消费开关：true-开启，false-关闭")
    private Boolean upTotalConsumerStatus;

    @ApiModelProperty("升级累计消费月数")
    private Integer upTotalConsumerMonthNum;

    @ApiModelProperty("升级累计消费金额")
    private Integer upTotalConsumerAmount;

    @ApiModelProperty("升级累计飞行开关：true-开启，false-关闭")
    private Boolean upTotalFlightStatus;

    @ApiModelProperty("升级累计飞行月数")
    private Integer upTotalFlightMonthNum;

    @ApiModelProperty("升级累计飞行次数")
    private Integer upTotalFlightNumber;

    @ApiModelProperty("升级累计条件关系：true-且，false-或")
    private Boolean upTotalIsAnd;

    @ApiModelProperty("升级单笔消费开关：true-开启，false-关闭")
    private Boolean upSingleConsumerStatus;

    @ApiModelProperty("升级单笔消费金额")
    private Integer upSingleConsumerAmount;

    @ApiModelProperty("降级累计消费开关：true-开启，false-关闭")
    private Boolean downTotalConsumerStatus;

    @ApiModelProperty("降级累计消费月数")
    private Integer downTotalConsumerMonthNum;

    @ApiModelProperty("降级累计消费金额")
    private Integer downTotalConsumerAmount;

    @ApiModelProperty("降级累计飞行开关：true-开启，false-关闭")
    private Boolean downTotalFlightStatus;

    @ApiModelProperty("降级累计飞行月数")
    private Integer downTotalFlightMonthNum;

    @ApiModelProperty("降级累计飞行次数")
    private Integer downTotalFlightNumber;

    @ApiModelProperty("降级累计条件关系：true-且，false-或")
    private Boolean downTotalIsAnd;

    @ApiModelProperty("操作人code")
    private String userCode;

    @ApiModelProperty("操作人")
    private String userName;

}
