package com.bizvane.members.feign.model.bo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

@Data
public class MbrIntegralRecordListRequestParam {

    @ApiModelProperty("变更单据")
    private String changeBills;

    @ApiModelProperty("会员卡号")
    private String cardNo;

    @ApiModelProperty("手机号")
    private String phone;

    @ApiModelProperty("变动类型1.支出,2.收入,3过期")
    private String changeWay;

    @ApiModelProperty("业务类型枚举IntegralBusinessWayEnum")
    private String businessWay;

    @ApiModelProperty("变更时间开始")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime changeDateStart;

    @ApiModelProperty("变更时间结束")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime changeDateEnd;

    private int pageNum = 1;

    private int pageSize  = 10;
}
