package com.bizvane.members.feign.model.bo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;

@AllArgsConstructor
@NoArgsConstructor
@Data
public class MbrLabelRecordListRequestParam {

    @ApiModelProperty("标签定义code")
    private String mbrLabelDefCode;

    @ApiModelProperty("会员卡号")
    private String cardNo;

    @ApiModelProperty("手机号")
    private String phone;

    @ApiModelProperty("操作标签类型 1帖标签 2撕标签")
    private Integer operateType;

    @ApiModelProperty("时间开始")
    private LocalDateTime createDateStart;

    @ApiModelProperty("时间结束")
    private LocalDateTime createDateEnd;

    private int pageNum = 1;

    private int pageSize  = 10;
}
