package com.bizvane.members.feign.model.bo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;
@NoArgsConstructor
@AllArgsConstructor
@Builder
@Data
public class MbrIntegralSubRequestParam {

    @ApiModelProperty("会员code")
    private String mbrMembersCode;

    @ApiModelProperty("变更单据")
    private String changeBills;

    @ApiModelProperty("变更来源")
    private String changeSource;

    @ApiModelProperty("变更积分")
    private Integer changeIntegral;

    @ApiModelProperty("变动时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime changeDate;

    @ApiModelProperty("变更详情")
    private String changeDetails;

    @ApiModelProperty("1积分过期,2保留原积分,3积分清零,4手动调整支出,5手动调整获取,6商品消费获取,7积分兑换支出,8游戏消耗支出,9开卡活动,10智能营销活动,11升级活动,12扫码领券活动,13手动领券活动,14消费活动,15签到活动,16生日活动,17完善资料任务,18微信分享任务,19消费金额任务,20消费次数任务,21邀请开卡任务,22纪念日活动,23评价奖励活动,24线下手动调整,25线下活动调整,26积分兑换券,27转盘活动,28红包膨胀活动,29砸金蛋活动,30积分商城消费积分,31积分商城返还积分,32首单开卡活动,33宝宝生日活动,34兑换有赞积分,35微商城积分扣减,36微商城积分返还,-1积分补偿,37摇一摇,38储值送礼,39佣金兑换,40天猫消费积分,42调查问卷任务,100赠送,101消费,102退货,103积分调整减积分,104积分调整增积分,105积分兑换,106积分抵现,107积分抵现返还,108积分清零,109赠送退回,110其它")
    private String businessWay;

    @ApiModelProperty("机场编号")
    private String airportNo;

    @ApiModelProperty("行业")
    private String industryNo;

    @ApiModelProperty("商户编号")
    private String merchantNo;

    @ApiModelProperty("修改人code")
    private String userCode;

    @ApiModelProperty("修改人")
    private String userName;

}
