package com.bizvane.members.feign.model.bo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;

@Data
public class MbrFrozenRecordListRequestParam {

    @ApiModelProperty("会员卡号")
    private String cardNo;

    @ApiModelProperty("手机号")
    private String phone;

    @ApiModelProperty("类型,1:冻结 2: 解冻")
    private Integer cardStatus;

    @ApiModelProperty("操作时间开始")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createDateStart;

    @ApiModelProperty("操作时间结束")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createDateEnd;

    private int pageNum = 1;

    private int pageSize  = 10;
}
