package com.bizvane.members.feign.model.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 会员冻结记录表
 * </p>
 *
 * @author Trump
 * @since 2024-09-13
 */
@Data
public class MbrFrozenRecordVO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("会员冻结记录code")
    private String mbrFrozenRecordCode;

    @ApiModelProperty("会员表code")
    private String mbrMembersCode;

    @ApiModelProperty("会员卡号")
    private String cardNo;

    @ApiModelProperty("手机号")
    private String phone;

    @ApiModelProperty("会员名称")
    private String name;

    @ApiModelProperty("类型,1:冻结 2: 解冻")
    private Integer cardStatus;

    @ApiModelProperty("冻结原因")
    private String cause;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建人id")
    private String createUserCode;

    @ApiModelProperty("创建人")
    private String createUserName;

    @ApiModelProperty("冻结/解冻时间")
    private LocalDateTime createDate;
}
