package com.bizvane.members.feign.model.bo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.time.LocalDateTime;

@Data
public class CouponGiveRequestParam {

    @NotEmpty
    @ApiModelProperty("券实例code")
    private String couponEntityCode;

    @NotBlank
    @ApiModelProperty("被转赠人code")
    private String receivedMemberCode;

    @NotNull
    @ApiModelProperty("业务时间")
    private LocalDateTime businessTime;

}
