package com.bizvane.members.feign.model.bo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
public class CouponDefinitionAddRequestParam {

    @ApiModelProperty("券所属编号")
    private Integer airportNoOrg;

    @ApiModelProperty("券生成渠道：1-crm生成，2-外部系统")
    private Integer generationChannel;

    @ApiModelProperty("外部系统券编码")
    private String externalSystemCouponCode;

    @ApiModelProperty("券名称")
    private String couponName;

    @ApiModelProperty("描述")
    private String info;

    @ApiModelProperty("优惠类型（1现金,2折扣,3兑换）")
    private Integer preferentialType;

    @ApiModelProperty("券的面额")
    private BigDecimal money;

    @ApiModelProperty("券的折扣")
    private BigDecimal discount;

    @ApiModelProperty("有效期类型：1-日期区间，2-领取后X天有效，3-仅限会员生日当天使用，4-仅限会员生日当月使用 5 领取后X天生效 效期X天")
    private Integer validType;

    @ApiModelProperty("有效期开始时间")
    private LocalDateTime validDateStart;

    @ApiModelProperty("有效期结束时间")
    private LocalDateTime validDateEnd;

    @ApiModelProperty("有效天数")
    private Integer validDay;

    @ApiModelProperty("最低消费金额(满减金额)")
    private BigDecimal minConsume;

    @ApiModelProperty("最高优惠金额")
    private BigDecimal maxPreferential;

    @ApiModelProperty("整单最低折扣限制")
    private BigDecimal minDiscount;

    @ApiModelProperty("是否允许转赠（1允许转赠，0不允许转赠）")
    private Boolean isTransfer;

    @ApiModelProperty("活动叠加条件：1-不允许叠加其他活动使用，2-允许叠加其他活动使用，3-允许部分活动使用")
    private Integer activitySuperpositionType;

    @ApiModelProperty("适用范围：1-业态，2-商户")
    private Integer scopeType;

    @ApiModelProperty("适用机场编号")
    private String scopeAirportNo;

    @ApiModelProperty("业态编号")
    private String scopeIndustryNoList;

    @ApiModelProperty("商户编号")
    private String scopeMerchantNoList;

    @ApiModelProperty("券模板图片")
    private String img;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建人code")
    private String userCode;

    @ApiModelProperty("创建人")
    private String userName;

}
