package com.bizvane.members.feign.model.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
public class CouponEntityListResponseParam {

    @ApiModelProperty("会员卡号")
    private String cardNo;

    @ApiModelProperty("会员名称")
    private String name;

    @ApiModelProperty("会员手机号")
    private String phone;

    @ApiModelProperty("券表code")
    private String couponEntityCode;

    @ApiModelProperty("券号")
    private String couponNo;

    @ApiModelProperty("会员code")
    private String mbrMembersCode;

    @ApiModelProperty("券编号")
    private String couponDefinitionCode;

    @ApiModelProperty("券所属机构编号")
    private Integer airportNoOrg;

    @ApiModelProperty("券生成渠道：1-crm生成，2-外部系统")
    private Integer generationChannel;

    @ApiModelProperty("外部系统券编码")
    private String externalSystemCouponCode;

    @ApiModelProperty("券名称")
    private String couponName;

    @ApiModelProperty("描述")
    private String info;

    @ApiModelProperty("优惠类型（1现金,2折扣,3兑换）")
    private Byte preferentialType;

    @ApiModelProperty("券的面额")
    private BigDecimal money;

    @ApiModelProperty("券的折扣")
    private BigDecimal discount;

    @ApiModelProperty("有效期类型：1-日期区间，2-领取后X天有效，3-仅限会员生日当天使用，4-仅限会员生日当月使用 5 领取后X天生效 效期X天")
    private Byte validType;

    @ApiModelProperty("有效期开始时间")
    private LocalDateTime validDateStart;

    @ApiModelProperty("有效期结束时间")
    private LocalDateTime validDateEnd;

    @ApiModelProperty("有效天数")
    private Integer validDay;

    @ApiModelProperty("最低消费金额(满减金额)")
    private BigDecimal minConsume;

    @ApiModelProperty("最高优惠金额")
    private BigDecimal maxPreferential;

    @ApiModelProperty("整单最低折扣限制")
    private BigDecimal minDiscount;

    @ApiModelProperty("是否允许转赠（1允许转赠，0不允许转赠）")
    private Boolean isTransfer;

    @ApiModelProperty("活动叠加条件：1-不允许叠加其他活动使用，2-允许叠加其他活动使用，3-允许部分活动使用")
    private Integer activitySuperpositionType;

    @ApiModelProperty("适用范围：1-业态，2-商户")
    private Integer scopeType;

    @ApiModelProperty("适用机场编号")
    private String scopeAirportNo;

    @ApiModelProperty("业态编号")
    private String scopeMerchantNoList;

    @ApiModelProperty("商户编号")
    private String scopeIndustryNoList;

    @ApiModelProperty("发放类型（10-开卡发券，15-会员生日，20-受赠，25-积分兑换，30-线上开卡，35-会员升级，--40-会员生日，45-会员消费，50-会员签到，55-领券，60-完善资料，65-微信分享，70-消费次数，75-消费金额，80-邀请开卡, 81-调查问卷,85-批量发券,90-入会纪念日,95-定向营销 ，100 - 评价奖励活动，101 - 积分商城，103大转盘，104红包膨胀，105-砸金蛋，106-宝宝生日活动，107-会员首单活动，108-摇一摇，109-储值送礼，110-预生成券，111-员工券，115 - 线下ERP发券，120 - 天猫券，125 - 线下领券 ,130-自动营销, 135-神策发放）")
    private Integer sendType;

    @ApiModelProperty("发券业务单号")
    private String sendBusinessCode;

    @ApiModelProperty("发券业务描述")
    private String sendBusinessName;

    @ApiModelProperty("使用类型：1-crm系统，2-外部系统")
    private Integer useType;

    @ApiModelProperty("核销人的会员code")
    private String useMemberCode;

    @ApiModelProperty("核销机场编号")
    private String useAirportNo;

    @ApiModelProperty("核销业态编号")
    private String useMerchantNo;

    @ApiModelProperty("核销商户编号")
    private String useIndustryNo;

    @ApiModelProperty("券使用订单号")
    private String useBusinessCode;

    @ApiModelProperty("券使用订单金额")
    private BigDecimal useBusinessAmount;

    @ApiModelProperty("使用时间")
    private LocalDateTime useTime;

    @ApiModelProperty("20-未使用，25-已过期，30-已核销")
    private Integer couponStatus;

    private String failDetail;

    @ApiModelProperty("转赠状态：1-转增中，2-已完成，3-已撤回")
    private Integer giveStatus;

    @ApiModelProperty("条形码url")
    private String barcodeUrl;

    @ApiModelProperty("二维码url")
    private String qrcodeUrl;

    @ApiModelProperty("创建人code")
    private String createUserCode;

    @ApiModelProperty("创建人")
    private String createUserName;

    @ApiModelProperty("创建日期")
    private LocalDateTime createDate;

    @ApiModelProperty("修改人code")
    private String modifiedUserCode;

    @ApiModelProperty("修改人")
    private String modifiedUserName;

    @ApiModelProperty("修改时间")
    private LocalDateTime modifiedDate;

}
