package com.bizvane.members.feign.model.bo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.time.LocalDateTime;
@NoArgsConstructor
@AllArgsConstructor
@Builder
@Data
public class CouponManualUpdateStatusRequestParam implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("手工发券code")
    @NotBlank
    private String couponManualCode;

    @ApiModelProperty("状态")
    private Integer taskStatus;

    @ApiModelProperty("成功数量（增量）")
    private Integer successCount;

    @ApiModelProperty("失败数量（增量）")
    private Integer failCount;
}
