package com.bizvane.members.feign.service;

import com.bizvane.members.feign.model.bo.MbrIntegralRegistrationAddRequestParam;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@FeignClient(value="${feign.client.members.name}",path="${feign.client.members.path}/integralRegistration")
@Api("积分登记")
public interface IntegralRegistrationFeign {

    @ApiOperation(value = "增加积分")
    @RequestMapping(value="/add", method = RequestMethod.POST)
    ResponseData<String> add(@RequestBody MbrIntegralRegistrationAddRequestParam param);
}
