package com.bizvane.members.feign.model.bo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
public class MbrIntegralRegistrationAddRequestParam {

    @ApiModelProperty("会员code")
    @NotBlank
    private String mbrMembersCode;

    @ApiModelProperty("会员卡号")
    private String cardNo;

    @ApiModelProperty("手机号")
    private String phone;

    @ApiModelProperty("订单号")
    @NotBlank
    private String orderNo;

    @ApiModelProperty("支付金额")
    @NotNull
    private BigDecimal payMoney;

    @ApiModelProperty("商户编号")
    @NotBlank
    private String merchantNo;
}