package com.bizvane.members.feign.model.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
public class OrderVO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("code")
    private String mbrOrderCode;

    @ApiModelProperty("会员code")
    private String mbrMembersCode;

    @ApiModelProperty("是否会员订单：1-是，0-否")
    private Boolean memberOrder;

    @NotBlank
    @ApiModelProperty("订单号")
    private String orderNo;

    @NotNull
    @ApiModelProperty("订单标志：1-订单，2-退单")
    private Integer orderFlag;

    @ApiModelProperty("原始订单号")
    private String originalOrderNo;

    @ApiModelProperty("订单状态 1:待付款,2:待发货,3:待收货,4:待评价,5:已取消,6:已全退,7:退款中,8:已评价,9:退货中")
    private String orderStatus;

    @NotNull
    @ApiModelProperty("折扣价 * 数量")
    private BigDecimal tradeAmount;

    @NotNull
    @ApiModelProperty("下单时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime placeOrderTime;

    @NotNull
    @ApiModelProperty("支付时间 ")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime payTime;

    @NotNull
    @ApiModelProperty("支付金额")
    private BigDecimal payMoney;

    @NotBlank
    @ApiModelProperty("机场编号")
    private String airportNo;

    @NotBlank
    @ApiModelProperty("行业")
    private String industryNo;

    @NotBlank
    @ApiModelProperty("商户编号")
    private String merchantNo;

    @ApiModelProperty("创建人code")
    private String userCode;

    @ApiModelProperty("创建人")
    private String userName;

}
