package com.bizvane.members.feign.service;

import com.bizvane.members.feign.model.bo.MbrStatusAddRequestParam;
import com.bizvane.members.feign.model.bo.MbrStatusListRequestParam;
import com.bizvane.members.feign.model.vo.MbrStatusVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.data.repository.query.Param;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value="${feign.client.members.name}",path="${feign.client.members.path}/mbrStatus")
@Api("会员状态管理")
public interface MbrStatusFeign {

  @ApiOperation(value = "新增黑白名单")
  @RequestMapping(value="/add", method = RequestMethod.POST)
  ResponseData<Boolean> add(@RequestBody MbrStatusAddRequestParam param);

  @ApiOperation(value = "删除黑白名单")
  @RequestMapping(value="/delete", method = RequestMethod.POST)
  ResponseData<Boolean> delete(@RequestParam("mbrStatusCode") String mbrStatusCode);

  @ApiOperation(value = "查询黑名名单列表")
  @RequestMapping(value="/list", method = RequestMethod.POST)
  PageInfo<MbrStatusVO> list(@RequestBody MbrStatusListRequestParam param);

  @ApiOperation(value = "查询黑白名单详情")
  @RequestMapping(value="/detail", method = RequestMethod.POST)
  MbrStatusVO detail(@RequestParam("mbrStatusCode") String mbrStatusCode);

}
