package com.bizvane.members.feign.model.bo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
public class MbrFlightRecordAddRequestParam {

    @ApiModelProperty("航班记录号")
    private String flightRecordNo;

    @ApiModelProperty("会员code")
    private String mbrMembersCode;

    @ApiModelProperty("航班号")
    private String flightNo;

    @ApiModelProperty("出发机场")
    private String departureAirport;

    @ApiModelProperty("到达机场")
    private String arrivalAirport;

    @ApiModelProperty("出发时间")
    private LocalDateTime departureDate;

    @ApiModelProperty("到达时间")
    private LocalDateTime arrivalDate;

    @ApiModelProperty("座位号")
    private String seatNumber;

    @ApiModelProperty("机票价格")
    private BigDecimal ticketPrice;

    @ApiModelProperty("预定时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime bookingDate;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("操作人code")
    private String userCode;

    @ApiModelProperty("操作人")
    private String userName;
}
