package com.bizvane.members.feign.service;

import com.bizvane.members.feign.model.bo.*;
import com.bizvane.members.feign.model.vo.*;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(value="${feign.client.members.name}",path="${feign.client.members.path}/mbrGroup")
@Api("会员分组")
public interface MbrGroupFeign {

  @ApiOperation(value = "查询分组目录列表")
  @RequestMapping(value="/listTypeDef", method = RequestMethod.POST)
  ResponseData<List<MbrGroupTypeDefVO>> listTypeDef();

  @ApiOperation(value = "新增分组目录")
  @RequestMapping(value="/addTypeDef", method = RequestMethod.POST)
  ResponseData<String> addTypeDef(@RequestBody MbrGroupTypeDefAddRequestParam param);

  @ApiOperation(value = "删除分组目录")
  @RequestMapping(value="/deleteTypeDef", method = RequestMethod.POST)
  ResponseData<Boolean> deleteTypeDef(@RequestParam("mbrLabelTypeDefCode") String mbrLabelTypeDefCode);

  @ApiOperation(value = "更新分组目录")
  @RequestMapping(value="/updateTypeDef", method = RequestMethod.POST)
  ResponseData<Boolean> updateTypeDef(@RequestBody MbrGroupTypeDefUpdateRequestParam param);

  @ApiOperation(value = "移动分组目录")
  @RequestMapping(value="/moveTypeDef", method = RequestMethod.POST)
  ResponseData<Boolean> moveTypeDef(@RequestBody MbrGroupTypeDefMoveRequestParam param);

  @ApiOperation(value = "查询分组列表")
  @RequestMapping(value="/listDef", method = RequestMethod.POST)
  ResponseData<PageInfo<MbrGroupDefVO>> listDef(@RequestBody MbrGroupDefListRequestParam param);

  @ApiOperation(value = "新增分组")
  @RequestMapping(value="/addDef", method = RequestMethod.POST)
  ResponseData<String> addDef(@RequestBody MbrGroupDefAddRequestParam param);

  @ApiOperation(value = "编辑分组")
  @RequestMapping(value="/updateDef", method = RequestMethod.POST)
  ResponseData<Boolean> updateDef(@RequestBody MbrGroupDefUpdateRequestParam param);

  @ApiOperation(value = "删除分组")
  @RequestMapping(value="/deleteDef", method = RequestMethod.POST)
  ResponseData<Boolean> deleteDef(@RequestParam("mbrLabelDefCode") String mbrLabelDefCode);

}