package com.bizvane.members.feign.service;

import com.bizvane.members.feign.model.bo.*;
import com.bizvane.members.feign.model.vo.MbrIntegralGeneralRuleVO;
import com.bizvane.members.feign.model.vo.MbrIntegralRecordVO;
import com.bizvane.members.feign.model.vo.MbrIntegralRuleVO;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.BeanUtils;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.data.repository.query.Param;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.ArrayList;
import java.util.List;

@FeignClient(value="${feign.client.members.name}",path="${feign.client.members.path}/integralRule")
@Api("积分规则管理")
public interface IntegralRuleFeign {

    @ApiOperation(value = "查询通用积分规则")
    @RequestMapping(value="/getGeneralRule", method = RequestMethod.POST)
    ResponseData<MbrIntegralGeneralRuleVO> getGeneralRule();

    @ApiOperation(value = "保存通用积分规则")
    @RequestMapping(value="/saveGeneralRule", method = RequestMethod.POST)
    ResponseData<String> saveGeneralRule(@RequestBody MbrIntegralGeneralRuleAddBO bo);

    @ApiOperation(value = "新增特殊规则")
    @RequestMapping(value="/add", method = RequestMethod.POST)
    ResponseData<String> add(@RequestBody MbrIntegralRuleAddRequestParam param);

    @ApiOperation(value = "更新特殊规则")
    @RequestMapping(value="/update", method = RequestMethod.POST)
    ResponseData<Boolean> update(@RequestBody MbrIntegralRuleUpdateRequestParam param);

    @ApiOperation(value = "删除特殊规则")
    @RequestMapping(value="/delete", method = RequestMethod.POST)
    ResponseData<Boolean> delete(@RequestBody MbrIntegralRuleDeleteRequestParam param);

    @ApiOperation(value = "查看特殊规则详情")
    @RequestMapping(value="/detail", method = RequestMethod.POST)
    ResponseData<MbrIntegralRuleVO> detail(@Param("mbrIntegralRuleCode") String mbrIntegralRuleCode);

    @ApiOperation(value = "修改特殊规则状态")
    @RequestMapping(value="/updateStatus", method = RequestMethod.POST)
    ResponseData<Boolean> updateStatus(@RequestBody MbrIntegralRuleUpdateStatusRequestParam param);

    @ApiOperation(value = "分页查询特殊规则列表")
    @RequestMapping(value="/list", method = RequestMethod.POST)
    ResponseData<PageInfo<MbrIntegralRuleVO>> list(@RequestBody MbrIntegralRuleListRequestParam param);
}
