package com.bizvane.members.feign.service;

import com.bizvane.members.feign.model.bo.CouponDefinitionListRequestParam;
import com.bizvane.members.feign.model.bo.CouponDefinitionAddRequestParam;
import com.bizvane.members.feign.model.bo.CouponDefinitionUpdateStatusRequestParam;
import com.bizvane.members.feign.model.vo.CouponDefinitionVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.data.repository.query.Param;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@FeignClient(value="${feign.client.members.name}",path="${feign.client.members.path}/couponDef")
@Api("券定义管理")
public interface CouponDefFeign {

  @ApiOperation(value = "新增")
  @RequestMapping(value="/add", method = RequestMethod.POST)
  ResponseData<String> add(@RequestBody CouponDefinitionAddRequestParam param);

  @ApiOperation(value = "列表查询")
  @RequestMapping(value="/list", method = RequestMethod.POST)
  PageInfo<CouponDefinitionVO> list(@RequestBody CouponDefinitionListRequestParam param);

  @ApiOperation(value = "详情")
  @RequestMapping(value="/detail", method = RequestMethod.POST)
  CouponDefinitionVO detail(@Param("couponDefinitionCode") String couponDefinitionCode);

  @ApiOperation(value = "更新状态")
  @RequestMapping(value="/updateStatus", method = RequestMethod.POST)
  ResponseData<Boolean> updateStatus(@RequestBody CouponDefinitionUpdateStatusRequestParam param);
}