package com.bizvane.members.feign.model.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 券转增记录表
 * </p>
 *
 * @author Trump
 * @since 2024-10-16
 */
@Data
public class CouponTransferLogVO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("pkid")
    private Long id;

    @ApiModelProperty("券转赠记录code")
    private String couponTransferLogCode;

    @ApiModelProperty("券定义编号")
    private String couponDefinitionCode;

    @ApiModelProperty("券实例code")
    private String couponEntityCode;

    @ApiModelProperty("外部系统券编码")
    private String externalSystemCouponCode;

    @ApiModelProperty("券名称")
    private String couponName;

    @ApiModelProperty("券号")
    private String couponNo;

    @ApiModelProperty("业务时间")
    private LocalDateTime businessTime;

    @ApiModelProperty("转赠人code")
    private String transferMemberCode;

    @ApiModelProperty("转赠人姓名")
    private String transferMemberName;

    @ApiModelProperty("转赠人卡号")
    private String transferCardNo;

    @ApiModelProperty("转赠人手机号")
    private String transferPhone;

    @ApiModelProperty("被转赠人code")
    private String receivedMemberCode;

    @ApiModelProperty("被转赠人姓名")
    private String receivedMemberName;

    @ApiModelProperty("被转赠人卡号")
    private String receivedCardNo;

    @ApiModelProperty("被转赠人手机号")
    private String receivedPhone;

    @ApiModelProperty("转赠状态：1-转增中，2-已完成，3-已撤回")
    private Integer giveStatus;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建人code")
    private String createUserCode;

    @ApiModelProperty("创建人")
    private String createUserName;

    @ApiModelProperty("创建日期")
    private LocalDateTime createDate;

    @ApiModelProperty("修改人code")
    private String modifiedUserCode;

    @ApiModelProperty("修改人")
    private String modifiedUserName;

    @ApiModelProperty("修改时间")
    private LocalDateTime modifiedDate;
}
