package com.bizvane.members.feign.model.bo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
@Data
public class OrderDetailBO {

    @NotBlank
    @ApiModelProperty("商品名称")
    private String productName;

    @ApiModelProperty("商品编号")
    private String productNo;

    @NotNull
    @ApiModelProperty("购买数量")
    private BigDecimal quantityDecimal;

    @NotNull
    @ApiModelProperty("折扣价")
    private BigDecimal discountPrice;

    @NotNull
    @ApiModelProperty("成交价（成交价 = 折扣价 = 吊牌价x折扣率）")
    private BigDecimal tradeAmountDetail;

    @NotNull
    @ApiModelProperty("订单详情成交价总金额(trade_amount_detail*数量)")
    private BigDecimal tradeDetailTotalAmount;

}
