package com.bizvane.members.feign.model.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;


@Data
public class MbrStatusVO implements Serializable {


    @ApiModelProperty("黑白名单记录code")
    private String mbrStatusCode;

    @ApiModelProperty("会员卡号")
    private String cardNo;

    @ApiModelProperty("手机号")
    private String phone;

    @ApiModelProperty("会员名称")
    private String name;

    @ApiModelProperty("类型,1-黑名单 2-白名单")
    private Integer statusFlag;

    @ApiModelProperty("操作原因")
    private String cause;

    @ApiModelProperty("创建人id")
    private String createUserCode;

    @ApiModelProperty("创建人")
    private String createUserName;

    @ApiModelProperty("创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime createDate;
}
