package com.bizvane.members.feign.model.bo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.LocalTime;

/**
 * <p>
 * 航班信息表
 * </p>
 *
 * @author Trump
 * @since 2024-12-24
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
public class BasicFlightSaveReq implements Serializable {

    private static final long serialVersionUID = 1L;

    //NEW-新增, MOD-修改(默认，相当于 Merge),DEL-删除
    private String operationMode;

    @ApiModelProperty("航班计划日期yyyy-MM-dd, A: 计划上 / 撤轮挡日期 B: 计划落地 / 起飞日期")
    private String flightScheduledDate;

    @ApiModelProperty("航班号全称")
    private String flightIdentity;

    @ApiModelProperty("FlightDirection 和 FlightRoute 至少必填一项，A - 到港，D - 离港")
    private String flightDirection;

    @ApiModelProperty("当前航段，IATA 代码的航段表示")
    private String flightRoute;

    @ApiModelProperty("基地机场 IATA 代码")
    private String baseAirportIataCode;

    @ApiModelProperty("基地机场 ICAO 代码")
    private String baseAirportIcaoCode;

    @ApiModelProperty("航班计划进出港时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime flightScheduledDateTime;

    @ApiModelProperty("航班调整计划进出港时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime flightAdjustScheduledDateTime;

    @ApiModelProperty("航空公司(承运人)二字码")
    private String airlineIataCode;

    @ApiModelProperty("航空公司(承运人)三字码")
    private String airlineIcaoCode;

    @ApiModelProperty("航空公司中文简称")
    private String airlineCn;

    @ApiModelProperty("航空公司英文简称")
    private String airlineEn;

    @ApiModelProperty("飞机机型三字码")
    private String aircraftIataCode;

    @ApiModelProperty("飞机机型四字码")
    private String aircraftIcaoCode;

    @ApiModelProperty("航班服务种类 CAAC 标准代码")
    private String flightCaacServiceType;

    @ApiModelProperty("预留字段，兼容 IATA 标准的航班性质")
    private String flightIataServiceType;

    @ApiModelProperty("始发机场 IATA")
    private String iataOriginAirport;

    @ApiModelProperty("前站机场 IATA")
    private String iataPreviousAirport;

    @ApiModelProperty("始发机场 ICAO")
    private String icaoOriginAirport;

    @ApiModelProperty("前站机场 ICAO")
    private String icaoPreviousAirport;

    @ApiModelProperty("前站机场中文简称")
    private String cnPreviousAirport;

    @ApiModelProperty("始发机场英文简称")
    private String enOriginAirport;

    @ApiModelProperty("前站机场英文简称")
    private String enPreviousAirport;

    @ApiModelProperty("下站机场 IATA")
    private String iataNextAirport;

    @ApiModelProperty("目的机场 IATA")
    private String iataDestinationAirport;

    @ApiModelProperty("下站机场 ICAO")
    private String icaoNextAirport;

    @ApiModelProperty("目的机场 ICAO")
    private String icaoDestinationAirport;

    @ApiModelProperty("下站机场中文")
    private String cnNextAirport;

    @ApiModelProperty("下站机场英文")
    private String enNextAirport;

    @ApiModelProperty("目的机场英文")
    private String enDestinationAirport;

    @ApiModelProperty("航线 IATA")
    private String iataFullRoute;

    @ApiModelProperty("航线 ICAO")
    private String icaoFullRoute;

    @ApiModelProperty("航线中文")
    private String cnFullRoute;

    @ApiModelProperty("国家类型")
    private String flightCountryType;

    @ApiModelProperty("共享航班号")
    private String slaveFlight;

    @ApiModelProperty("营运状态")
    private String operationStatus;

    @ApiModelProperty("营运状态中文")
    private String operationStatusCn;

    @ApiModelProperty("原始航班状态")
    private String originalFlightStatus;

    @ApiModelProperty("航班状态")
    private String flightStatus;

    @ApiModelProperty("航班状态中文")
    private String flightStatusCn;

    @ApiModelProperty("内部延误原因代码")
    private String internalDelayReason;

    @ApiModelProperty("外部延误原因代码")
    private String externalDelayReason;

    @ApiModelProperty("取消原因代码")
    private String cancelReason;

    @ApiModelProperty("延误文本详细")
    private String delayTextCombination;

    @ApiModelProperty("VIP 航班标志")
    private String isVipFlight;

    @ApiModelProperty("是否过站航班")
    private String isTransitFlight;

    @ApiModelProperty("是否过夜航班")
    private String isOvernightFlight;

    @ApiModelProperty("是否临界航班")
    private String criticalMark;

    @ApiModelProperty("计划飞行时长")
    private Integer scheduledFlyTime;

    @ApiModelProperty("预计飞行时长")
    private Integer estimatedFlyTime;

    @ApiModelProperty("预计滑入时长")
    private Integer estimatedTaxiInTime;

    @ApiModelProperty("实际滑入时长")
    private Integer actualTaxiInTime;

    @ApiModelProperty("预计滑出时长")
    private Integer estimatedTaxiOutTime;

    @ApiModelProperty("实际滑出时长")
    private Integer actualTaxiOutTime;

    @ApiModelProperty("前站航班计划起飞时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime scheduledPreviousAirportDepartureDateTime;

    @ApiModelProperty("前站航班预计起飞时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime estimatedPreviousAirportDepartureDateTime;

    @ApiModelProperty("前站航班实际起飞时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime actualPreviousAirportDepartureDateTime;

    @ApiModelProperty("计划落地时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime scheduledLandingDateTime;

    @ApiModelProperty("预计落地时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime estimatedLandingDateTime;

    @ApiModelProperty("实际落地时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime actualLandingDateTime;

    @ApiModelProperty("首件行李时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime firstBaggageDateTime;

    @ApiModelProperty("末件行李时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime lastBaggageDateTime;

    @ApiModelProperty("预计关客舱门时间")
    private LocalDateTime estimatedDoorCloseDateTime;

    @ApiModelProperty("实际关客舱门时间")
    private LocalDateTime actualDoorCloseDateTime;

    @ApiModelProperty("航班值机开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime checkInOpenDateTime;

    @ApiModelProperty("航班值机关闭时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime checkInCloseDateTime;

    @ApiModelProperty("预计登机")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime estimatedBoardingStartDateTime;

    @ApiModelProperty("登机开始")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime boardingStartDateTime;

    @ApiModelProperty("催促登机")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime lastCallDateTime;

    @ApiModelProperty("登机结束")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime boardingEndDateTime;

    @ApiModelProperty("计划起飞时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime scheduledTakeOffDateTime;

    @ApiModelProperty("预计起飞时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime estimatedTakeOffDateTime;

    @ApiModelProperty("实际起飞时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime actualTakeOffDateTime;

    @ApiModelProperty("下站计划到达时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime scheduledNextAirportArrivalDateTime;

    @ApiModelProperty("下站预计到达时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime estimatedNextAirportArrivalDateTime;

    @ApiModelProperty("下站实际到达时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime actualNextAirportArrivalDateTime;

    @ApiModelProperty("航班取消时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime cancellationDateTime;

    @ApiModelProperty("实际开客舱门时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime actualDoorOpenDateTime;

    @ApiModelProperty("实际开始下机时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime deboardingStartDateTime;

    @ApiModelProperty("跑道编号")
    private String runwayId;

    @ApiModelProperty("进港或离港机位")
    private String standId;

    @ApiModelProperty("当前飞机所在机位")
    private String currentStandId;

    @ApiModelProperty("航班航站楼")
    private String flightTerminalId;

    @ApiModelProperty("航班卫星厅")
    private String concourse;

    @ApiModelProperty("逗号分隔的登机门编号列表")
    private String gates;

    @ApiModelProperty("逗号分隔的行李提取转盘列表")
    private String baggageReclaims;

    @ApiModelProperty("逗号分隔的值机区域列表")
    private String counterAreas;

    @ApiModelProperty("值机柜台列表")
    private String counters;

    @ApiModelProperty("登机桥列表 - 预留")
    private String airbridges;

    @ApiModelProperty("登机门发布状态")
    private String publishStatusGate;

    @ApiModelProperty("行李提取转盘发布状态")
    private String publishStatusBaggageReclaim;

    @ApiModelProperty("机位发布状态")
    private String publishStatusStand;

    @ApiModelProperty("值机柜台发布状态")
    private String publishStatusCheckInDesk;

}
