package com.bizvane.members.feign.model.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@AllArgsConstructor
@NoArgsConstructor
@Data
public class BasicAerodromeVO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("首字母")
    private String firstLetter;

    @ApiModelProperty("通航点列表")
    private List<BasicAerodromeSubVO> list = new ArrayList<>();

    @AllArgsConstructor
    @NoArgsConstructor
    @Data
    public static class BasicAerodromeSubVO {

        @ApiModelProperty("三字码")
        private String threeCode;

        @ApiModelProperty("中文名")
        private String zhName;
    }
}
