package com.bizvane.members.facade.models;

import com.bizvane.members.facade.utils.EncryptPhone;
import com.bizvane.mktcenterservice.models.bo.ActivityGameBO;
import com.bizvane.mktcenterservice.models.po.MktActivityPO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @Author: houkai
 * @Date: 2018/7/24 13:49
 * @Description:订单信息
 */
@Data
@NoArgsConstructor
@Table(name = "t_mbr_order")
public class OrderModel extends BaseModel implements Serializable {

    private static final long serialVersionUID = 8234999977106474060L;

    @Id
    @ApiModelProperty(value = "订单主键", name = "mbrOrderId", example = "订单主键")
    private Long mbrOrderId;

    @ApiModelProperty(value = "所属会员", name = "memberCode", example = "所属会员")
    private String memberCode;

    @ApiModelProperty(value = "所属企业id", name = "sysCompanyId", example = "所属企业id")
    private Long sysCompanyId;

    @ApiModelProperty(value = "品牌id", name = "brandId", example = "品牌id")
    private Long brandId;

    @ApiModelProperty(value = "订单号", name = "orderNo", example = "订单号")
    private String orderNo;

    private String sourceCode; //来源渠道code

    private String wmActivityType; //微盟活动类型
    @ApiModelProperty(value = "订单来源1:线下零售单,3：云仓订单，2：微商城", name = "orderFrom", example = "订单来源")
    private Integer orderFrom;

    @ApiModelProperty(value = "订单状态 1:待付款,2:待发货,3:待收货,4:待评价,5:已取消,6:已全退,7:退款中,8:已评价,9:退货中", name = "orderStatus", example = "订单状态")
    private String orderStatus;

    @ApiModelProperty(value = "订单类型,1.商城订单,2.积分订单", name = "orderType", example = "订单类型,1.商城订单,2.积分订单")
    private Integer orderType;

    @ApiModelProperty(value = "购物方式,1：快递,2：自提,3：预约", name = "shopWay", example = "购物方式,1：快递,2：自提,3：预约")
    private Integer shopWay;

    @ApiModelProperty(value = "自提门店id", name = "fetchStoreId", example = "自提门店id")
    private Long fetchStoreId;

    @ApiModelProperty(value = "买家备注", name = "buyerRemark", example = "买家备注")
    private String buyerRemark;

    @ApiModelProperty(value = "使用积分", name = "usedIntegral", example = "使用积分")
    private Integer usedIntegral;

    @ApiModelProperty(value = "是否奖励积分1:是,2：否", name = "rewardIntegral", example = "是否奖励积分1:是,2：否")
    private Integer rewardIntegral;

    @ApiModelProperty(value = "获得积分", name = "getedIntegral", example = "获得积分")
    private Integer getedIntegral;

    @ApiModelProperty(value = "赠送券号", name = "giveTicketno", example = "赠送券号")
    private String giveTicketno;

    @ApiModelProperty(value = "优惠金额", name = "preferentialAmount", example = "优惠金额")
    private BigDecimal preferentialAmount;

    @ApiModelProperty(value = "抵扣金额", name = "deductibleAmount", example = "抵扣金额")
    private BigDecimal deductibleAmount;

    @ApiModelProperty(value = "商品金额,成交总额", name = "commodityAmount", example = "商品金额,成交总额")
    private BigDecimal commodityAmount;

    @ApiModelProperty(value = "成交金额(优惠卷+抵扣卷)", name = "tradeAmount", example = "成交金额(优惠卷+抵扣卷)")
    private BigDecimal tradeAmount;

    @ApiModelProperty(value = "标准金额没有优惠的金额", name = "standardAmount", example = "标准金额没有优惠的金额")
    private BigDecimal standardAmount;

    @ApiModelProperty(value = "其他优惠卷金额(满减,包邮)", name = "otherPreferentialVolume", example = "其他优惠卷金额(满减,包邮)")
    private BigDecimal otherPreferentialVolume;

    @ApiModelProperty(value = "下单时间", name = "placeOrderTime", example = "下单时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date placeOrderTime;

    @ApiModelProperty(value = "下单数量", name = "placeOrderCount", example = "下单数量")
    private Integer placeOrderCount;

    @ApiModelProperty(value = "支付时间", name = "payTime", example = "支付时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date payTime;

    @ApiModelProperty(value = "支付金额", name = "payMoney", example = "支付金额")
    private BigDecimal payMoney;

    @ApiModelProperty(value = "物流单号", name = "logisticsNo", example = "物流单号")
    private String logisticsNo;

    @ApiModelProperty(value = "商品数量(发货数量)", name = "productCount", example = "商品数量(发货数量)")
    private Integer productCount;

    @ApiModelProperty(value = "商品数量小数型", name = "productCountDecimal", example = "商品数量小数型")
    private BigDecimal productCountDecimal;

    @ApiModelProperty(value = "物流公司ID(关联到物流公司)", name = "logisticsId", example = "物流公司ID(关联到物流公司)")
    private Long logisticsId;

    @ApiModelProperty(value = "收货人的信息地址", name = "consigneeAddress", example = "收货人的信息地址")
    private String consigneeAddress;

    @EncryptPhone
    @ApiModelProperty(value = "收货人的手机", name = "consigneePhone", example = "收货人的手机")
    private String consigneePhone;

    @ApiModelProperty(value = "收货人的姓名信息", name = "consigneeName", example = "收货人的姓名信息")
    private String consigneeName;

    @ApiModelProperty(value = "收货人的详细地址", name = "consigneeDetailed", example = "收货人的详细地址")
    private String consigneeDetailed;

    @ApiModelProperty(value = "收货人的省份", name = "consigneeProvince", example = "收货人的省份")
    private String consigneeProvince;

    @ApiModelProperty(value = "收货人的城市", name = "consigneeCity", example = "收货人的城市")
    private String consigneeCity;

    @ApiModelProperty(value = "收货人的区", name = "consigneeArea", example = "收货人的区")
    private String consigneeArea;

    @ApiModelProperty(value = "收货人的街道号", name = "consigneeStreet", example = "收货人的街道号")
    private String consigneeStreet;

    @ApiModelProperty(value = "确认收货时间", name = "comfirmTime", example = "确认收货时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date comfirmTime;

    @ApiModelProperty(value = "已发货数量", name = "deliveredCount", example = "已发货数量")
    private Integer deliveredCount;

    @ApiModelProperty(value = "邮费(不包邮应收金额)", name = "postage", example = "邮费(不包邮应收金额)")
    private BigDecimal postage;

    @ApiModelProperty(value = "所属公众号", name = "wxPublicId", example = "所属公众号")
    private Long wxPublicId;

    @ApiModelProperty(value = "发货时间", name = "sendTime", example = "发货时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date sendTime;

    @ApiModelProperty(value = "退货数量", name = "quitOrderCount", example = "退货数量")
    private Integer quitOrderCount;

    @ApiModelProperty(value = "退款金额", name = "quitOrderPrice", example = "退款金额")
    private BigDecimal quitOrderPrice;

    @ApiModelProperty(value = "关联优惠券", name = "couponId", example = "关联优惠券")
    private Long couponId;

    @ApiModelProperty(value = "服务门店", name = "serviceStoreId", example = "服务门店")
    private Long serviceStoreId;

    @ApiModelProperty(value = "服务门店名", name = "serviceStoreName", example = "服务门店名")
    private String serviceStoreName;

    @ApiModelProperty(value = "服务门店地址", name = "serviceStoreSite", example = "服务门店地址")
    private String serviceStoreSite;

    @ApiModelProperty(value = "会员当前导购code", name = "serviceGuideCode", example = "会员当前导购code")
    private String serviceGuideCode;

    @ApiModelProperty(value = "微盟导购code", name = "wmGuideCode")
    private String wmGuideCode;

    @ApiModelProperty(value = "会员当前导购id", name = "serviceGuideId", example = "会员当前导购id")
    private Long serviceGuideId;

    @ApiModelProperty(value = "订单门店导购name", name = "serviceGuideName", example = "订单门店导购name")
    private String serviceGuideName;

    @ApiModelProperty(value = "是否包邮1:包邮,2自费", name = "freePostage", example = "是否包邮1:包邮,2自费")
    private Integer freePostage;

    @ApiModelProperty(value = "取消订单时间", name = "cancelOrderTime", example = "取消订单时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date cancelOrderTime;

    @ApiModelProperty(value = "评价状态:1=未评价;2=已评价;3=已退货", name = "evaluateStatus", example = "评价状态:1=未评价;2=已评价;3=已退货")
    private Integer evaluateStatus;

    @ApiModelProperty(value = "发货门店", name = "sendStore", example = "发货门店")
    private String sendStore;

    @ApiModelProperty(value = "订单详情", name = "details", example = "订单详情")
    @OneToMany(mappedBy = "t_mbr_order", cascade = CascadeType.ALL, fetch = FetchType.LAZY)
    @JoinColumn(name = "orderNo")
    @Transient
    private List<OrderDetailModel> details;

    @ApiModelProperty(value = "订单正负类型:1=正订单;2=退货订单;", name = "plusMinusType", example = "订单正负类型:1=正订单;2=退货订单")
    private Integer plusMinusType;

    @ApiModelProperty(value = "线下品牌code", name = "offlineBrandCode", example = "线下品牌code")
    private String offlineBrandCode;

    @ApiModelProperty(value = "线下企业code", name = "offlineBrandCode", example = "线下企业code")
    private String offlineCompanyCode;

    @ApiModelProperty(value = "订单门店线下code", name = "serviceStoreCode", example = "订单门店线下code")
    private String serviceStoreCode;

    @ApiModelProperty(value = "线下更新时间", name = "offlineUpdateDate", example = "线下更新时间")
    private Date offlineUpdateDate;

    @ApiModelProperty(value = "线下会员id", name = "erpId", example = "线下会员id")
    private String erpId;

    @ApiModelProperty(value = "ur卡号", name = "urCardCode", example = "ur卡号")
    private String cardCode;

    @ApiModelProperty(value = "收银", name = "urCashier", example = "收银")
    private String cashier;

    @ApiModelProperty(value = "退单时间", name = "originalOrderDate", example = "退单时间")
    private Date originalOrderDate;

    @ApiModelProperty(value = "订单多导购提成比例", name = "serviceGuideProportion", example = "订单多导购提成比例")
    private String serviceGuideProportion;

    @ApiModelProperty(value = "订单多导购导购id", name = "serviceGuideIds", example = "订单多导购导购id")
    private String serviceGuideIds;

    @ApiModelProperty(value = "订单多导购姓名", name = "serviceGuideNames", example = "订单多导购姓名")
    private String serviceGuideNames;

    @ApiModelProperty(value = "订单标志  0是订单1是退单 ",name = "orderFlag")
    private Integer orderFlag;

    @ApiModelProperty(value = "发票号",name = "invoiceNo")
    private String invoiceNo;

    @ApiModelProperty(value = "发票金额",name = "invoiceMoney")
    private BigDecimal invoiceMoney;


    @ApiModelProperty(value = "原始订单号", name = "originalOrderNo")
    private String originalOrderNo;

    private String guideNames;

    @ApiModelProperty(value = "账单时间", name = "billTime", example = "账单时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date billTime;

    @ApiModelProperty(value = "会员手机号",name = "phone")
    @EncryptPhone
    private String phone;

    /**
     * 订单绑定最老可执行游戏对象
     */
    private ActivityGameBO activityGameBO;
}
