package com.bizvane.members.facade.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.Date;

@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class MemberChannelRespVo {

    private String channelName;

    private Long channelId;

    private String sourceCode;

    private String sourceName;

    private String nickName;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime time;

    private String addOrBind;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime qkBindTime;

    /**
     * 可解绑类型,1可以解绑,0不可以解绑
     */
    private Integer doUnbindType = 0;
}
