package com.bizvane.members.facade.service.inner;

import com.bizvane.members.facade.models.RegionModel;
import com.bizvane.members.facade.models.RegionNameModel;
import com.bizvane.utils.responseinfo.ResponseData;

import java.util.List;

/**
 * @Author: houkai
 * @Date: 2018/7/20 13:58
 * @Description: 区域
 */
public interface RegionService {
    /**
     * 查询区域列表
     * @param code
     * @return
     */
    ResponseData<List<RegionModel>> queryRegionList(Integer code);

    /**
     * 查询区域tree
     * @param code
     * @return
     */
    List<RegionModel> queryRegionTree(Integer code);

    /**
     * 解析文件查询区域treeJson
     * @return
     * @throws Exception
     */
    ResponseData<List<RegionModel>> queryRegionTreeJson();

    RegionNameModel getRegionName(String provinceCode, String cityCode, String countyCode);
}
