package com.bizvane.members.facade.service.api;/*
 * @author gp.n
 * @date 2020-12-18
 *
 * */

import com.bizvane.members.facade.vo.GetHuaiRenDrugServerRecordListRequestVO;
import com.bizvane.members.facade.vo.UpdateAndInsertHuaiRenDrugServerRecordRequestVO;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;


@FeignClient(value = "${feign.client.members.name}",path = "${feign.client.members.path}/huaiRen")
public interface HuaiRenDrugServerApiService {
    //获取预定药品记录表内容
    @PostMapping("/getDrugServerRecordList")
    public ResponseData getDrugServerRecordList(@RequestBody GetHuaiRenDrugServerRecordListRequestVO listRequestVO);
    //新增预定药品记录
    @PostMapping("/insertDrugServerRecord")
    ResponseData insertDrugServerRecord(@RequestBody UpdateAndInsertHuaiRenDrugServerRecordRequestVO requestVO);
    //获取详情
    @GetMapping
    ResponseData getDrugServerRecordById(@RequestParam(value = "mbrDrugReserveId") Long mbrDrugReserveId);
}
