package com.bizvane.members.facade.es.pojo;

import java.io.Serializable;

import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.Document;

import lombok.Data;
import lombok.EqualsAndHashCode;

@Data
@EqualsAndHashCode
@Document(indexName = "t_mbr_members", type = "doc")
public class MembersGroupAnalyzePojo implements Serializable {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	// polarDB mbr主键id
	@Id
	private Long mbrmemberid;
	// 会员code
	private String membercode;
	// 线下品牌id
	private String offlinebrandcode;
	// 线下会员id
	private String vipid;
	// 国家
	private String county;
	// 省份
	private String province;
	// 市
	private String city;
	// 生日
	private String birthday;
	// 等级id(线上)
	private Long levelid;
	// 线下等级code
	private String offlinelevelcode;
	// 渠道id-----------
	private String mbrchannelid;
	// 渠道编码----------
	private String channelcode;
	// 冗余生日时间的格式月日
	private String birthdaymd;
	// 性别
	private String gender;
	// 开卡天数
	private int newmember;
	// 会员活跃度
	private String memberliveness;
	// 累计消费金额
	private String consumeamountall;
}
