package com.bizvane.members.facade.service.card.request;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.time.LocalDate;
import java.time.LocalDateTime;

@Data
public class IntegraRecordListReq {

	private Long sysCompanyId;

	@NotBlank
	private String brandCode;

	private String offlineOrgCode;

	@NotBlank
	private String memberCode;

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
	private LocalDateTime changeDateStart;

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
	private LocalDateTime changeDateEnd;

	@NotNull
	private Integer pageNum;

	@NotNull
	private Integer pageSize;

}
