package com.bizvane.members.facade.models;

import com.bizvane.members.facade.vo.tree3.IntegralMallQueryIntegralListRsp;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @Author: Hou Hong Bin
 * @CreateTime: 2018/7/14.
 * 积分流水
 */
@Data
@NoArgsConstructor
@Table(name = "t_mbr_integral_record")
public class IntegralRecordModel extends BaseModel implements Serializable {

    private static final long serialVersionUID = 2525064822676778029L;

    @ApiModelProperty(value = "积分流水id", name = "mbrIntegralRecordId")
    private Integer mbrIntegralRecordId;

    @Deprecated
    @ApiModelProperty(value = "积分流水id", name = "integralRecordId", example = "积分流水id")
    private Integer integralRecordId;

    @ApiModelProperty(value = "企业id", name = "sysCompanyId", example = "企业id")
    private Long sysCompanyId;

    @ApiModelProperty(value = "品牌id", name = "brandId", example = "品牌id")
    private Long brandId;

    @Transient
    @ApiModelProperty("渠道名称")
    private String channelName;

    @ApiModelProperty("渠道id")
    private Long sysChannelId;

    @Transient
    @ApiModelProperty("事业部名称")
    private String offlineOrgName;

    @ApiModelProperty("事业部code")
    private String offlineOrgCode;

    @ApiModelProperty(value = "流水编号", name = "recordCode", example = "流水编号")
    private String recordCode;

    @ApiModelProperty(value = "会员code", name = "memberCode", example = "会员code")
    private String memberCode;

    @ApiModelProperty(value = "变更单据", name = "changeBills", example = "变更单据")
    private String changeBills;

    @ApiModelProperty(value = "变更积分", name = "changeIntegral", example = "变更积分")
    private Integer changeIntegral;

    @Transient
    private List<IntegralMallQueryIntegralListRsp> orgIntegralList;

    @ApiModelProperty(value = "变更时间", name = "changeDate", example = "变更时间")
    private Date changeDate;

    @ApiModelProperty(value = "变更类型", name = "changeWay", example = "变更类型")
    private String changeWay;

    @ApiModelProperty(value = "变更类型名称", name = "changeWayName", example = "变更类型名称")
    private String changeWayName;

    @ApiModelProperty(value = "变更详情", name = "changeDetails", example = "变更详情")
    private String changeDetails;

    @ApiModelProperty(value = "业务类型", name = "businessWay", example = "业务类型")
    private String businessWay;

    @ApiModelProperty(value = "业务类型名称", name = "businessWayName", example = "业务类型名称")
    private String businessWayName;

    @ApiModelProperty(value = "积分有效期", name = "effetiveTime", example = "积分有效期")
    private Date effectiveTime;

    @ApiModelProperty(value = "变更积分max", name = "changeIntegralMax")
    private Integer changeIntegralMax;

    @ApiModelProperty(value = "变更积分min", name = "changeIntegralMin")
    private Integer changeIntegralMin;

    @ApiModelProperty(value = "会员姓名", name = "memberName")
    private String memberName;

    @ApiModelProperty(value = "会员手机号", name = "memberPhone")
    private String memberPhone;

    @ApiModelProperty(value = "会员卡号", name = "cardNo")
    private String cardNo;

    @ApiModelProperty(value = "变更时间最大值", name = "changeDateMax")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date changeDateMax;

    @ApiModelProperty(value = "变更时间最小值", name = "changeDateMin")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date changeDateMin;

    @ApiModelProperty(value = "高级搜索", name = "searchValue")
    private String searchValue;

    @ApiModelProperty(value = "线下企业code", name = "companyCode", example = "线下企业code")
    private String offlineCompanyCode;

    @ApiModelProperty(value = "线下品牌code", name = "brandCode", example = "线下品牌code")
    private String offlineBrandCode;

    @ApiModelProperty(value = "线下积分流水id", name = "offlineIntegralId", example = "线下积分流水id")
    private String offlineIntegralId;

    @ApiModelProperty(value = "当前用户管辖店铺列表", name = "storeList", example = "当前用户管辖店铺列表")
    @Transient
    private List<Long> storeList;

    @ApiModelProperty(value = "线下会员id", name = "erpId", example = "线下会员id")
    private String erpId;

    @ApiModelProperty(value = "会员卡号", name = "memberCardNo")
    private String memberCardNo;

    @ApiModelProperty(value = "积分数额", name = "pointsAmount")
    private Integer pointsAmount;

    @ApiModelProperty(value = "店铺id", name = "storeId")
    private String storeId;

    @ApiModelProperty(value = "积分来源", name = "source")
    private String source;

    @ApiModelProperty(value = "业务类型描述，关联积分流水业务类型字典表描述", name = "businessDescription")
    private String businessDescription;

    private String offlineStoreCode;
    /**
     * 从第几条记录开始 导出excel使用
     */
    private Long start;
    /**
     * 读取几条记录 导出excel使用
     */
    private Long size;

    @ApiModelProperty(value = "线上门店code", name = "onlineStoreCode")
    private String onlineStoreCode;

    private Long pageNumber;

    private int pageSize;

    @ApiModelProperty("消费门店")
    private String consumeStore;

    @ApiModelProperty("所属门店")
    private String serviceStore;

    @ApiModelProperty("分销商")
    private String distributorName;

    @ApiModelProperty(value = "线下积分类型",name = "businessWayOffline")
    private String businessWayOffline;

    @Transient
    @ApiModelProperty(value = "企业下会员条件集合",name = "memberCodeList")
    private String memberCodeList;

    private boolean isIntegralMall;
}
