package com.bizvane.members.facade.service.datafetch.model;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author: houkai
 * @Date: 2018/11/8 13:49
 * @Description:
 */
@Data
public class MemberIntegralFetchModel extends BaseFetchModel implements Serializable {

    private Integer countIntegral; //会员累计可用总积分

    private Integer addUpIntegral; //累计收入的总积分

    private Integer aboutExpireIntegral; //即将到期积分

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date aboutExpireTime;//即将到期时间

    @ApiModelProperty(value = "已过期积分", name = "pastDueIntegral", example = "已过期积分")
    private Integer pastDueIntegral;

    @ApiModelProperty(value = "已消耗积分", name = "consumeIntegral", example = "已消耗积分")
    private Integer consumeIntegral;

    @ApiModelProperty(value = "冻结积分", name = "consumeIntegral", example = "冻结积分")
    private Integer freezeIntegral;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date offlineUpdateIntegralDate;
}
