package com.bizvane.members.facade.service.api;

import com.bizvane.members.facade.models.query.IntegralMallOrgIntegralAdjustRes;
import com.bizvane.members.facade.models.query.IntegralMallQueryOrgIntegralListReq;
import com.bizvane.members.facade.service.card.request.IntegralChangeRequestModel;
import com.bizvane.members.facade.service.card.response.IntegralChangeResponseModel;
import com.bizvane.members.facade.vo.SyncIntegralVo;
import com.bizvane.members.facade.vo.tree3.IntegralMallQueryIntegralListRsp;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

/**
 * @Author: Hou Hong Bin
 * @CreateTime: 2018/8/18.
 */
@FeignClient(value = "${feign.client.members.name}",path = "${feign.client.members.path}")
public interface IntegralChangeApiService {
    /**
     * 积分变动操作
     * @param integralChangeRequestModel
     * @return
     */
    @RequestMapping(value = "/api/integralChangeOperate", method = RequestMethod.POST)
    public IntegralChangeResponseModel integralChangeOperate(@RequestBody IntegralChangeRequestModel integralChangeRequestModel);

    /**
     * 线下积分流水同步到线上
     * @param vo
     * @return
     */
    @RequestMapping(value = "/api/offlineSyncIntegral", method = RequestMethod.POST)
    ResponseData offlineSyncIntegral(@RequestBody SyncIntegralVo vo);


    @RequestMapping(value = "/api/integralMallQueryIntegralList", method = RequestMethod.POST)
    ResponseData<List<IntegralMallQueryIntegralListRsp>> integralMallQueryIntegralList(@RequestBody IntegralMallQueryOrgIntegralListReq req);

    @RequestMapping(value = "/api/integralMallIntegralAdjust", method = RequestMethod.POST)
    ResponseData<Object> integralMallIntegralAdjust(@RequestBody IntegralMallOrgIntegralAdjustRes req);

    /**
     * 补数据使用
     * @param syncIntegralVo
     * @return
     */
    @RequestMapping(value = "/api/offlineSyncIntegralConsume", method = RequestMethod.POST)
    ResponseData offlineSyncIntegralConsume(@RequestBody SyncIntegralVo syncIntegralVo);

    /**
     * 百胜积分流水同步线上
     * @param vo
     * @return
     */
    @RequestMapping(value = "/api/baisonSyncIntegralRecord", method = RequestMethod.POST)
    ResponseData baisonSyncIntegralRecord(@RequestBody SyncIntegralVo vo);
}
