package com.bizvane.members.facade.service.api361;

import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.vo.*;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

@FeignClient(value = "${feign.client.members.name}", path = "${feign.client.members.path}")
public interface Api361Service {


    @RequestMapping(value = "/api/api361/addOrder", method = RequestMethod.POST)
    ResponseData<OpenApiOrderResponseVo> addOrder(@RequestBody @Valid OpenApiOrderRequestVo openApiOrderRequestVo);

    @RequestMapping(value = "/api/api361/addStandardOrder", method = RequestMethod.POST)
    ResponseData<StandardOrderResponseVo> addStandardOrder(@RequestBody StandardOrderRequestVo standardOrderRequestVo);

    @RequestMapping(value = "/api/api361/addStandardNonMemberOrder", method = RequestMethod.POST)
    ResponseData<StandardOrderResponseVo> addStandardNonMemberOrder(@RequestBody StandardOrderRequestVo standardOrderRequestVo);

    @RequestMapping(value = "/api/api361/queryMembers", method = RequestMethod.POST)
    ResponseData<List<MemberInfoModel>> queryMembers(@RequestParam("sysCompanyId") Long sysCompanyId, @RequestParam("erpId") String erpId);

    @RequestMapping(value = "/api/api361/queryIntegralRecord", method = RequestMethod.POST)
    ResponseData<Integer> queryIntegralRecord(@RequestParam("sysCompanyCode") String sysCompanyCode, @RequestParam("sysBrandCode") String sysBrandCode, @RequestParam("offlineIntegralId") String offlineIntegralId);

    @RequestMapping(value = "/api/api361/queryMembersMultiparameter", method = RequestMethod.POST)
     ResponseData<List<MemberInfoModel>> queryMembersMultiparameter(@RequestParam("sysCompanyId") Long sysCompanyId, @RequestParam("erpId") String erpId,@RequestParam("phone") String phone,@RequestParam("wxUnionId") String wxUnionId);

    @RequestMapping(value = "/api/api361/queryMembersDemogic", method = RequestMethod.POST)
    ResponseData<MbrIcrmInfoVo> queryMembersDemogic(@RequestParam("sysCompanyId") Long sysCompanyId, @RequestParam("erpId") String erpId, @RequestParam("phone") String phone, @RequestParam("wxUnionId") String wxUnionId, @RequestParam("storeCode") String storeCode);

    @RequestMapping(value = "/api/api361/queryStoreCode", method = RequestMethod.POST)
    ResponseData<String> queryStoreCode(@RequestParam("brandCode") String brandCode, @RequestParam("phone") String phone,@RequestParam("corpId") Long corpId);

}
