package com.bizvane.members.facade.enums.tree3;

public enum Tree3LevelNonMemberEnum {

    QZKH(1, "QZKH"),
    XFZ(10, "XFZ"),
    SJS(15, "SJS"),
    FXS(20, "FXS");

    private final Integer type;
    private final String levelCode;

    Tree3LevelNonMemberEnum(int type, String levelCode) {
        this.type = type;
        this.levelCode = levelCode;
    }

    public static String getLevelCode(Integer type) {
        for (Tree3LevelNonMemberEnum status : values()) {
            if (status.getType().equals(type)) {
                return status.getLevelCode();
            }
        }
        return null;
    }

    public Integer getType() {
        return type;
    }

    public String getLevelCode() {
        return levelCode;
    }
}
