package com.bizvane.members.facade.service.inner;

import com.bizvane.members.facade.models.query.IntegralMallOrgIntegralAdjustRes;
import com.bizvane.members.facade.models.query.IntegralMallQueryOrgIntegralListReq;
import com.bizvane.members.facade.vo.tree3.IntegralMallQueryIntegralListRsp;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.bizvane.members.facade.service.card.request.IntegralChangeForTmallReqVo;
import com.bizvane.members.facade.service.card.request.IntegralChangeRequestModel;
import com.bizvane.members.facade.service.card.response.IntegralChangeResponseModel;
import com.bizvane.members.facade.service.datafetch.model.DisableIntegralResetAboutExpireModel;
import com.bizvane.members.facade.vo.SyncIntegralVo;
import com.bizvane.utils.responseinfo.ResponseData;

import javax.validation.Valid;
import java.util.List;

/**
 * @Author: Hou Hong Bin
 * @CreateTime: 2018/8/18.
 */
public interface IntegralChangeService {

    /**
     * 积分变动操作
     *
     * @param integralChangeRequestModel
     * @return
     */
    @RequestMapping(value = "/api/integralChangeOperate", method = RequestMethod.POST)
    IntegralChangeResponseModel integralChangeOperate(@RequestBody IntegralChangeRequestModel integralChangeRequestModel);

    /**
     * 线下积分流水同步到线上
     *
     * @param vo
     * @return
     */
    @RequestMapping(value = "/api/offlineSyncIntegral", method = RequestMethod.POST)
    ResponseData offlineSyncIntegral(@RequestBody SyncIntegralVo vo);

    List<IntegralMallQueryIntegralListRsp> integralMallQueryIntegralList(IntegralMallQueryOrgIntegralListReq req);

    ResponseData<Object> integralMallIntegralAdjust(IntegralMallOrgIntegralAdjustRes req);
    /**
     * 补数据使用
     *
     * @param syncIntegralVo
     * @return
     */
    @RequestMapping(value = "/api/offlineSyncIntegralConsume", method = RequestMethod.POST)
    ResponseData offlineSyncIntegralConsume(@RequestBody SyncIntegralVo syncIntegralVo);

    /**
     * baison同步积分流水
     * @param vo
     * @return
     */
    @RequestMapping(value = "/api/baisonSyncIntegralRecord", method = RequestMethod.POST)
    ResponseData baisonSyncIntegralRecord(SyncIntegralVo vo);

    /**
     * 批量即将过期积分调整(归零)
     *
     * @param vo
     * @return
     */
    @RequestMapping(value = "/api/batchChangeAboutExpireIntegral", method = RequestMethod.POST)
    ResponseData batchChangeAboutExpireIntegral(DisableIntegralResetAboutExpireModel vo);
}
