package com.bizvane.members.facade.service.card;

import com.bizvane.members.facade.service.card.request.PerfectMemberDataRequestModel;
import com.bizvane.members.facade.service.card.response.PerfectMemberDataResponseModel;
import com.bizvane.utils.enumutils.SysResponseEnum;

/**
 * @Author: Hou Hong Bin
 * @CreateTime: 2018/8/22.
 */
public abstract class AbstractApiPerfectMemberDataService {

    /**
     * 验证数据有效性
     * @param perfectMemberDataRequestModel
     * @return
     */
    public abstract void validationData(PerfectMemberDataRequestModel perfectMemberDataRequestModel);

    public abstract PerfectMemberDataResponseModel updateOnlineMemberData(PerfectMemberDataRequestModel perfectMemberDataRequestModel);

    public abstract PerfectMemberDataResponseModel asyncSendDataToOffline(PerfectMemberDataRequestModel perfectMemberDataRequestModel);


    protected PerfectMemberDataResponseModel perfect(PerfectMemberDataRequestModel perfectMemberDataRequestModel){
        //验证数据有效性
        this.validationData(perfectMemberDataRequestModel);

        PerfectMemberDataResponseModel perfectMemberDataResponseModel = null;
        //更新线上数据
        perfectMemberDataResponseModel = updateOnlineMemberData(perfectMemberDataRequestModel);

        if(perfectMemberDataResponseModel.getCode() == SysResponseEnum.SUCCESS.getCode()){
            //异步发送数据到线下
            perfectMemberDataResponseModel = asyncSendDataToOffline(perfectMemberDataRequestModel);
        }
        return perfectMemberDataResponseModel;
    }

}
