package com.bizvane.members.facade.enums.alipay.electcard;

import com.bizvane.members.facade.exception.MemberException;

public enum AlipayElectCardTemplateWriteOffTypeEnum {

    QRCODE(1,"qrcode","二维码，扫码得商户开卡传入的external_card_no"),
    BARCODE(0,"barcode","条形码，扫码得商户开卡传入的external_card_no");
    ;

    private int type;
    private String code;
    private String msg;

    AlipayElectCardTemplateWriteOffTypeEnum(int type, String code, String msg) {
        this.type = type;
        this.code = code;
        this.msg = msg;
    }

    public int getType() {
        return type;
    }

    public String getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }

    public static String getWriteOffTypeCode(Integer type) {
        if(type == null){
            throw new MemberException("支付宝会员码样式不能为空");
        }
        for (AlipayElectCardTemplateWriteOffTypeEnum writeOffTypeEnum : AlipayElectCardTemplateWriteOffTypeEnum.values()) {
            if (type == writeOffTypeEnum.getType()) {
                return writeOffTypeEnum.getCode();
            }
        }
        throw new MemberException("支付宝会员码样式不能为空");
    }
}
