package com.bizvane.members.facade.utils;

import com.bizvane.utils.redisutils.SpringContextHolder;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

@Slf4j
public class PhoneEncryptConfig {

    public static String encryptAES(Long sysCompanyId, String data) {
        log.info("加密开始:{},{}", sysCompanyId, data);
        EncryptPhoneProperties properties = SpringContextHolder.getBean(EncryptPhoneProperties.class);
        if (properties == null) {
            log.error("加密配置为空:{}", data);
            return data;
        }
        if (StringUtils.isBlank(data)) {
            log.info("加密数据为空:");
            return data;
        }

        try {
            return PhoneEncryptUtil.encryptAES(properties.getKey(), properties.getIv(), data);
        } catch (Exception e) {
            log.error("加密失败:{}", ExceptionUtils.getStackTrace(e));
        }
        return data;
    }

    public static String decryptAES(Long sysCompanyId, String data) {
        log.info("解密开始:{}", data);
        if (StringUtils.isBlank(data)) {
            log.info("解密数据为空:");
            return data;
        }
        EncryptPhoneProperties properties = SpringContextHolder.getBean(EncryptPhoneProperties.class);
        if (properties == null) {
            log.error("解密配置为空:{}", data);
            return data;
        }
        try {
            return PhoneEncryptUtil.decryptAES(properties.getKey(), properties.getIv(), data);
        } catch (Exception e) {
            log.error("解密失败:{}", ExceptionUtils.getStackTrace(e));
        }

        return data;
    }
}