package com.bizvane.members.facade.service.electcard;

import com.bizvane.members.facade.vo.MbrElectCardOpenErrorVo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;


/**
 * @author zcc
 * @date 2020/8/27 20:48
 **/
@FeignClient(value = "${feign.client.members.name}", path = "${feign.client.members.path}")
public interface MbrElectCardOpenErrorRpcService {
    /**
     * 电子会员卡回调开卡失败,保存电子会员卡信息
     * @param mbrElectCardOpenErrorVo
     * @return
     */
    @RequestMapping(value = "/api/memberElectCardOpenError/saveByVo", method = RequestMethod.POST)
    public ResponseData<Long> saveByVo(@RequestBody MbrElectCardOpenErrorVo mbrElectCardOpenErrorVo);

    /**
     * 电子会员卡回调开卡失败,修改电子会员卡信息
     * @param mbrElectCardOpenErrorVo
     * @return
     */
    @RequestMapping(value = "/api/memberElectCardOpenError/updateByVo", method = RequestMethod.POST)
    public ResponseData<Boolean> updateByVo(@RequestBody MbrElectCardOpenErrorVo mbrElectCardOpenErrorVo);

    /**
     * 获取用户电子会员卡回调开卡失败信息
     * @param mbrElectCardOpenErrorVo
     * @return
     */
    @RequestMapping(value = "/api/memberElectCardOpenError/getByVo", method = RequestMethod.POST)
    public ResponseData<MbrElectCardOpenErrorVo> getByVo(@RequestBody MbrElectCardOpenErrorVo mbrElectCardOpenErrorVo);

    /**
     * 删除用户电子会员卡回调开卡失败信息
     * @param mbrElectCardOpenErrorVo
     * @return
     */
    @RequestMapping(value = "/api/memberElectCardOpenError/deleteByVo", method = RequestMethod.POST)
    public ResponseData<Boolean> deleteByVo(@RequestBody MbrElectCardOpenErrorVo mbrElectCardOpenErrorVo);

}
