package com.bizvane.members.facade.enums;

import org.apache.commons.lang3.StringUtils;

public enum OrderFromEnum {
    /**
     * 订单来源 线下零售单
     */
    OFFLINE(1, "线下零售单"),
    /**
     * 订单来源 云仓订单
     */
    CLOUD(3, "云仓订单"),
    /**
     * 订单来源 微商城
     */
    MALL(2, "微商城");

    private Integer code;

    private String msg;

    OrderFromEnum(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public static String getName(String code) {
        if (StringUtils.isBlank(code)) {
            return "";
        }
        for (CardStatusEnum type : CardStatusEnum.values()) {
            if (code.equals(String.valueOf(type.getCode()))) {
                return type.getMsg();
            }
        }
        return "";
    }

    public static String getOrderFromName(Integer code) {
        if (code == null) {
            return "";
        }
        for (OrderFromEnum type : OrderFromEnum.values()) {
            if (code.equals(type.getCode())) {
                return type.getMsg();
            }
        }
        return "";
    }

}
