/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.members.facade.utils;

import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.Mode;
import cn.hutool.crypto.Padding;
import cn.hutool.crypto.symmetric.AES;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoneEncryptUtil {
    private static final Logger log = LoggerFactory.getLogger(PhoneEncryptUtil.class);
    private static final String encryptPrefix = "encrypt_";

    public static String encryptAES(String key, String iv, String data) throws Exception {
        if (StrUtil.isBlank((CharSequence)data)) {
            return data;
        }
        String[] split = data.split(",");
        StringBuilder stringBuffer = new StringBuilder("");
        for (String s : split) {
            if (StrUtil.isNotBlank((CharSequence)s) && !s.startsWith(encryptPrefix)) {
                s = encryptPrefix + PhoneEncryptUtil.encryptAes(key, iv, s);
            }
            stringBuffer.append(s).append(",");
        }
        String result = stringBuffer.substring(0, stringBuffer.length() - 1);
        log.info("PhoneEncryptUtil.encryptAES before: {}, after: {}", (Object)data, (Object)result);
        return result;
    }

    public static String decryptAES(String key, String iv, String data) throws Exception {
        if (StrUtil.isBlank((CharSequence)data)) {
            return data;
        }
        String[] split = data.split(",");
        StringBuilder stringBuffer = new StringBuilder("");
        for (String s : split) {
            if (StrUtil.isNotBlank((CharSequence)s) && s.startsWith(encryptPrefix)) {
                s = s.replace(encryptPrefix, "");
                s = PhoneEncryptUtil.decryptAes(key, iv, s);
            }
            stringBuffer.append(s).append(",");
        }
        String result = stringBuffer.substring(0, stringBuffer.length() - 1);
        log.info("PhoneEncryptUtil.decryptAES before: {}, after: {}", (Object)data, (Object)result);
        return result;
    }

    public static boolean isEncrypt(String data) {
        return StrUtil.isNotEmpty((CharSequence)data) && data.startsWith(encryptPrefix);
    }

    private static String encryptAes(String key, String iv, String data) {
        AES aes = new AES(Mode.CBC, Padding.PKCS5Padding, key.getBytes(), iv.getBytes());
        return aes.encryptHex(data, CharsetUtil.CHARSET_UTF_8);
    }

    private static String decryptAes(String key, String iv, String data) {
        AES aes = new AES(Mode.CBC, Padding.PKCS5Padding, key.getBytes(), iv.getBytes());
        return aes.decryptStr(data, CharsetUtil.CHARSET_UTF_8);
    }

    public static enum EncryptDecryptPhoneEnum {
        ENCRYPT(1, "\u52a0\u5bc6"),
        DECRYPT(2, "\u89e3\u5bc6");

        private int code;
        private String desc;

        private EncryptDecryptPhoneEnum(int code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public int getCode() {
            return this.code;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }
}

