package com.bizvane.members.facade.vo;

import com.bizvane.members.facade.models.po.MbrTiktokOrderDetailPO;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;


@Data
public class MbrTiktokOrderVo implements Serializable {


    /**
     * Database Column Remarks:
     * 订单号
     */
    @NotBlank(message = "订单号不能为空")
    private String orderId;

    /**
     * Database Column Remarks:
     * 抖音用户id
     */
    @NotBlank(message = "抖音用户id不能为空")
    private String openId;

    /**
     * Database Column Remarks:
     * 商家id
     */
    @NotBlank(message = "商家id不能为空")
    private String merchantId;


    /**
     * Database Column Remarks:
     * 所属企业id
     */
    private Long sysCompanyId;

    /**
     * Database Column Remarks:
     * 品牌id
     */
    private Integer brandId;

    /**
     * Database Column Remarks:
     * 订单状态
     * <p>
     * （OrderStatus_Init 初始化 OrderStatus = 0
     * <p>
     * OrderStatus_WaitPay 待支付 OrderStatus = 100
     * <p>
     * OrderStatus_Cancel 订单关闭 OrderStatus = 101
     * <p>
     * OrderStatus_PaySuccess 支付成功 OrderStatus = 200
     * <p>
     * OrderStatus_Available 待使用 OrderStatus = 201
     * <p>
     * OrderStatus_Finish 交易成功 OrderStatus = 1
     * <p>
     * OrderStatus_PartPay 部分支付  OrderStatus = 150）
     */
    private Integer orderStatus;

    /**
     * Database Column Remarks:
     * 订单创建时间
     */
    private Date createOrderTime;

    /**
     * Database Column Remarks:
     * 支付时间
     */
    private Date payTime;

    /**
     * Database Column Remarks:
     * 支付金额
     */
    private BigDecimal payMoney;

    /**
     * Database Column Remarks:
     * 商品id
     */
    private String productId;

    /**
     * Database Column Remarks:
     * 商品名
     */
    private String productName;

    /**
     * Database Column Remarks:
     * 商品数量
     */
    private Integer productCount;

    /**
     * Database Column Remarks:
     * 券数量
     */
    private Integer couponCount;
    /**
     * 订单明细
     */
    private List<MbrTiktokOrderDetailPO> orderDetailList;

}