package com.bizvane.members.facade.models.third;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author yuantq
 * @date 2023/12/5
 */
@Data
public class ThirdMbrIntegralChangeFlowBO implements Serializable {

    public ThirdMbrIntegralChangeFlowBO() {
        super();
    }

    private static final long serialVersionUID = 5669121063563278344L;

    public ThirdMbrIntegralChangeFlowBO(Long sysCompanyId, Long sysBrandId, String memberCode, String changeType, Integer changeIntegral
            , Integer residueIntegral, String relationPointsIdUnique, Date changeDate, String detail) {
        this.sysCompanyId = sysCompanyId;
        this.sysBrandId = sysBrandId;
        this.memberCode = memberCode;
        this.changeType = changeType;
        this.changeIntegral = changeIntegral;
        this.residueIntegral = residueIntegral;
        this.relationPointsIdUnique = relationPointsIdUnique;
        this.changeDate = changeDate;
        this.detail = detail;
    }

    @ApiModelProperty(value="企业id")
    private Long sysCompanyId;

    @ApiModelProperty(value="品牌id")
    private Long sysBrandId;

    @ApiModelProperty(value="会员code")
    private String memberCode;

    /**
     * 调整类型 1-支出，2-收入，3-过期
     */
    private String changeType;

    /**
     * 调整积分数量(正数)
     */
    private Integer changeIntegral;

    /**
     * 会员剩余积分
     */
    private Integer residueIntegral;

    /**
     * 关联积分流水id
     */
    private String relationPointsIdUnique;

    /**
     * 变更时间
     */
    private Date changeDate;

    /**
     * 调整详情
     */
    private String detail;
}
