package com.bizvane.members.facade.service.inner;

import com.bizvane.members.facade.models.MbrRechargeCardUpdateVo;
import com.bizvane.members.facade.models.MbrRechargeCardVo;
import com.bizvane.utils.responseinfo.ResponseData;

import java.util.List;

/**
 * @author zcc
 * @date 2022/2/17 11:38
 **/
public interface MbrRechargeCardService {

    /**
     * 查询会员储值卡信息列表
     *
     * @param sysCompanyId
     * @param sysBrandId
     * @param memberCode
     * @param cardSourceType
     * @return
     */
    ResponseData<List<MbrRechargeCardVo>> queryMbrRechargeCardList(Long sysCompanyId, Long sysBrandId, String memberCode, Integer cardSourceType);

    /**
     * 根据卡归属类型查询会员储值卡信息
     *
     * @param sysCompanyId
     * @param sysBrandId
     * @param memberCode
     * @param cardSourceType
     * @param organizationCode
     * @return
     */
    ResponseData<MbrRechargeCardVo> queryMbrRechargeCardByOrg(Long sysCompanyId, Long sysBrandId, String memberCode, Integer cardSourceType, String organizationCode);

    /**
     * 根据储值卡卡号查询储值卡信息
     *
     * @param sysCompanyId
     * @param sysBrandId
     * @param memberCode
     * @param petCardNo
     * @return
     */
    ResponseData<MbrRechargeCardVo> queryMbrRechargeCardByPetCardNo(Long sysCompanyId, Long sysBrandId, String memberCode, String petCardNo);

    /**
     * 修改储值卡余额
     * @param mbrRechargeCardUpdateVo
     * @return
     */
    ResponseData<String> updateMbrRechargeCardBalance(MbrRechargeCardUpdateVo mbrRechargeCardUpdateVo);
}
