package com.bizvane.members.facade.models;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
public class MemberAutoLabelDefSyncReq {

    @ApiModelProperty(value = "企业id", name = "sysCompanyId", example = "企业id")
    private Long sysCompanyId;

    @ApiModelProperty(value = "所属品牌", name = "brandId", example = "所属品牌")
    private Long brandId;

    @ApiModelProperty(value = "标签分组编号", name = "groupCode", example = "标签编号")
    private String groupCode;

    @ApiModelProperty(value = "标签分组名称", name = "groupName", example = "标签名称")
    private String groupName;

    @ApiModelProperty(value = "标签编号", name = "labelCode", example = "标签编号")
    private String labelCode;

    @ApiModelProperty(value = "标签名称", name = "labelName", example = "标签名称")
    private String labelName;

    @ApiModelProperty(value = "是否允许导购贴/撕标签 0-不允许 1-允许", name = "openStaff")
    private String action;
}
