package com.bizvane.members.facade.models;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
public class MemberLabelDefSyncReq {


    @ApiModelProperty(value = "企业id", name = "sysCompanyId", example = "企业id")
    private Long sysCompanyId;

    @ApiModelProperty(value = "所属品牌", name = "brandId", example = "所属品牌")
    private Long brandId;

    @ApiModelProperty(value = "标签编号", name = "labelCode", example = "标签编号")
    private String labelCode;

    @ApiModelProperty(value = "标签名称", name = "labelName", example = "标签名称")
    private String labelName;

    @ApiModelProperty(value = "标签值", name = "valueList", example = "标签分组")
    private List<String> valueList;

    // 是否允许导购贴、撕标签 0-不允许 1-允许（默认1）
    private Integer openStaff;

    @ApiModelProperty(value = "操作类型：add添加，del删除，update更新（只支持更新标签名称）", name = "openStaff")
    private String action;
}
