package com.bizvane.members.facade.models.bo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;

import java.math.BigDecimal;

@Data
@Builder
public class PayLevelCardBo {

    //等级id
    private Long mbrLevelId;
    //线下等级code
    private String offlineLevelCode;
    //等级名称
    private String levelName;
    //付费卡标志
    private Integer payFlag;
    //入会费
    private BigDecimal payMoney;
    //有效期
    private Integer effectiveYear;
    //到期等级变更
    private Integer levelChangeType;
    //到期等级变更为新等级id
    private Long newLevelId;

    @ApiModelProperty(value = "付费卡类型 1-年卡 2-季卡", name = "payCardType", example = "1")
    private Integer payCardType;


}
