package com.bizvane.members.facade.enums;

import com.bizvane.members.facade.constants.BasePropertyPrefix;

/**
 * @Author: Hou Hong Bin
 * @CreateTime: 2018/7/31.
 */
public enum BasePropertyEnum {
    /**
     * 姓名
     */
    NAME(BasePropertyPrefix.NAME_, "姓名"),
    /**
     * 生日
     */
    BIRTHDAY(BasePropertyPrefix.BIRTHDAY_, "生日"),
    /**
     * 省
     */
    PROVINCE(BasePropertyPrefix.PROVINCE_, "省"),
    /**
     * 市
     */
    CITY(BasePropertyPrefix.CITY_, "市"),
    /**
     * 区
     */
    COUNTY(BasePropertyPrefix.COUNTY_, "区/县"),
    /**
     * 详细地址
     */
    ADDRESSES(BasePropertyPrefix.ADDRESSES_, "详细地址组合"),
    /**
     * 性别
     */
    GENDER(BasePropertyPrefix.GENDER_, "性别"),
    /**
     * 邮箱
     */
    EMAIL(BasePropertyPrefix.EMAIL_, "邮箱"),
    /**
     * 手机号
     */
    PHONE(BasePropertyPrefix.PHONE_, "手机号"),
    /**
     * 服务门店
     */
    SERVICE_STORE(BasePropertyPrefix.SERVICE_STORE_, "服务门店"),
    /**
     * 服务导购
     */
    SERVICE_GUIDE(BasePropertyPrefix.SERVICE_GUIDE_, "服务导购"),
    /**
     * 会员等级
     */
    LEVEL(BasePropertyPrefix.LEVEL_, "会员等级"),
    /**
     * 积分余额
     */
    INTEGRAL(BasePropertyPrefix.INTEGRAL_, "积分余额"),
    /**
     * 开卡门店
     */
    OPENCARD_STORE(BasePropertyPrefix.OPENCARD_, "开卡门店"),
    /**
     * 开卡时间
     */
    OPENCARDDATE(BasePropertyPrefix.OPENCARDDATE, "开卡时间"),
    /**
     * 开卡导购
     */
    OPENGUIDE(BasePropertyPrefix.OPENGUIDE, "开卡导购"),
    /**
     * 会员等级
     */
    MEMBERLEVEL(BasePropertyPrefix.MEMBERLEVEL, "开卡导购"),
    /**
     * 累计消费（近1年）
     */
    CONSUMYEAR(BasePropertyPrefix.CONSUMYEAR, "开卡导购"),
    /**
     * 我的积分
     */
    MYINTEGRAL(BasePropertyPrefix.MYINTEGRAL, "开卡导购");

    private String code;

    private String msg;

    BasePropertyEnum(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public static BasePropertyEnum getBasePropertyEnum(String code) {
        if (code == null) {
            return null;
        }
        for (BasePropertyEnum type : BasePropertyEnum.values()) {
            if (code.startsWith(type.getCode())) {
                return type;
            }
        }
        return null;
    }
}
